import random
from collections import defaultdict

# Configuration
num_races = 1000
finish_counts = defaultdict(lambda: [0, 0, 0, 0, 0])  # Stores 1st to 5th place finishes

# Chance arrays
chance = list(range(1, 51))
chance3 = list(range(1, 6))

# Race simulation function
def simulate_race():
    positions = []
    biases = [1, 0.8, 0.6, 0.4, 0.2]  # horse1 to horse5
    for bias in biases:
        s = int(random.random() * len(chance3) / 2 + bias)
        pos = 0
        while pos < 1000:
            i = random.choice(chance)
            pos += i / 25 + s / 2
        positions.append(pos)
    return sorted(range(len(positions)), key=lambda x: -positions[x])  # Return finishing order

# Run the simulations
for _ in range(num_races):
    result = simulate_race()
    for place, horse in enumerate(result):
        finish_counts[horse][place] += 1

# Display results
for h in range(5):
    print(f"horse{h+1}: 1st={finish_counts[h][0]}, 2nd={finish_counts[h][1]}, 3rd={finish_counts[h][2]}, 4th={finish_counts[h][3]}, 5th={finish_counts[h][4]}")
